--*********************************DISCLAIMER*************************************
--We do not support 32-bit versions of SQL Server due to memory constraints
--********************************************************************************
-- UDF_mdAddr.sql
--
-- Adds the mdAddr user-defined functions to SQL Server.
--
-- You must have copied mdAddr.dll into the /Binn/ folder of you
--   SQL Server installation AND have already executed the
--   xp_mdAddr.sql script before running this script.

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrCreate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrCreate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrCreate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrCreate ()
      RETURNS INT AS BEGIN
         DECLARE @mdAddr INT
         EXECUTE master.dbo.xp_mdAddrCreate @mdAddr OUT
         RETURN @mdAddr
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrDestroy') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrDestroy
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrDestroy') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrDestroy (@mdAddr int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrDestroy @mdAddr
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrInitialize') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrInitialize
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrInitialize') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrInitialize (@mdAddr int, @Param0  varchar(4096), @Param1  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrInitialize @RetVal out,  @mdAddr, @Param0, @Param1
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrInitializeDataFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrInitializeDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrInitializeDataFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrInitializeDataFiles (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrInitializeDataFiles @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetInitializeErrorString') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetInitializeErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetInitializeErrorString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetInitializeErrorString (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetInitializeErrorString @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLicenseString') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetLicenseString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLicenseString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetLicenseString (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrSetLicenseString @RetVal out,  @mdAddr, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetBuildNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetBuildNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetBuildNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetBuildNumber (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetBuildNumber @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDatabaseDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDatabaseDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDatabaseDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDatabaseDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetExpirationDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetExpirationDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetExpirationDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetExpirationDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLicenseExpirationDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetLicenseExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLicenseExpirationDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetLicenseExpirationDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetLicenseExpirationDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCanadianDatabaseDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCanadianDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCanadianDatabaseDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCanadianDatabaseDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCanadianDatabaseDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCanadianExpirationDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCanadianExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCanadianExpirationDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCanadianExpirationDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCanadianExpirationDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToUSFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToUSFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToUSFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToUSFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToUSFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToCanadaFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToCanadaFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToCanadaFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToCanadaFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToCanadaFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToDPVDataFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToDPVDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToDPVDataFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToDPVDataFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToDPVDataFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToLACSLinkDataFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToLACSLinkDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToLACSLinkDataFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToLACSLinkDataFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToLACSLinkDataFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToSuiteLinkDataFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToSuiteLinkDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToSuiteLinkDataFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToSuiteLinkDataFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToSuiteLinkDataFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToSuiteFinderDataFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToSuiteFinderDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToSuiteFinderDataFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToSuiteFinderDataFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToSuiteFinderDataFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToRBDIFiles') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPathToRBDIFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPathToRBDIFiles') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPathToRBDIFiles (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPathToRBDIFiles @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCASSEnable') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetCASSEnable
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCASSEnable') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetCASSEnable (@mdAddr int, @Param0  int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetCASSEnable @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetUseUSPSPreferredCityNames') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetUseUSPSPreferredCityNames
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetUseUSPSPreferredCityNames') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetUseUSPSPreferredCityNames (@mdAddr int, @Param0  int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetUseUSPSPreferredCityNames @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetDiacritics') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetDiacritics
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetDiacritics') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetDiacritics (@mdAddr int, @Param0  int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetDiacritics @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetRBDIDatabaseDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetRBDIDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetRBDIDatabaseDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetRBDIDatabaseDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetRBDIDatabaseDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrClearProperties') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrClearProperties
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrClearProperties') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrClearProperties (@mdAddr int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrClearProperties @mdAddr
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetStatusCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetStatusCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetStatusCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetStatusCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetStatusCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetErrorCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetErrorCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetErrorCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetErrorCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetErrorCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetErrorString') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetErrorString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetErrorString (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetErrorString @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetResults') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetResults
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetResults') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetResults (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetResults @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_B1_ProcessorName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_B1_ProcessorName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_B1_ProcessorName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_B1_ProcessorName (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_B1_ProcessorName @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_B4_ListName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_B4_ListName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_B4_ListName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_B4_ListName (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_B4_ListName @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Name') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_Name
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Name') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_Name (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_Name @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Company') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_Company
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Company') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_Company (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_Company @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Address') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_Address
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_Address') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_Address (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_Address @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_City') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_City
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_City') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_City (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_City @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_State') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_State
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_State') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_State (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_State @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_ZIP') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPS3553_D3_ZIP
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPS3553_D3_ZIP') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPS3553_D3_ZIP (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPS3553_D3_ZIP @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFormPS3553') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetFormPS3553
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFormPS3553') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetFormPS3553 (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetFormPS3553 @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSaveFormPS3553') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSaveFormPS3553
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSaveFormPS3553') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSaveFormPS3553 (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrSaveFormPS3553 @RetVal out,  @mdAddr, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetFormPS3553') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrResetFormPS3553
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetFormPS3553') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrResetFormPS3553 (@mdAddr int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrResetFormPS3553 @mdAddr
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetDPV') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrResetDPV
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetDPV') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrResetDPV (@mdAddr int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrResetDPV @mdAddr
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFormSOA') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetFormSOA
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFormSOA') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetFormSOA (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetFormSOA @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSaveFormSOA') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSaveFormSOA
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSaveFormSOA') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSaveFormSOA (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSaveFormSOA @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetFormSOA') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrResetFormSOA
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrResetFormSOA') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrResetFormSOA (@mdAddr int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrResetFormSOA @mdAddr
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSOACustomerInfo') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetSOACustomerInfo
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSOACustomerInfo') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetSOACustomerInfo (@mdAddr int, @Param0  varchar(4096), @Param1  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetSOACustomerInfo @mdAddr, @Param0, @Param1
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSOACPCNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetSOACPCNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSOACPCNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetSOACPCNumber (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetSOACPCNumber @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOACustomerInfo') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOACustomerInfo
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOACustomerInfo') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOACustomerInfo (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSOACustomerInfo @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOACPCNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOACPCNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOACPCNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOACPCNumber (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSOACPCNumber @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOATotalRecords') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOATotalRecords
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOATotalRecords') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOATotalRecords (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetSOATotalRecords @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAAAPercentage') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOAAAPercentage
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAAAPercentage') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOAAAPercentage (@mdAddr int)
      RETURNS FLOAT(24) AS BEGIN
         declare @RetVal float(24)
         execute master.dbo.xp_mdAddrGetSOAAAPercentage @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAAAExpiryDate') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOAAAExpiryDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAAAExpiryDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOAAAExpiryDate (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSOAAAExpiryDate @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOASoftwareInfo') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOASoftwareInfo
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOASoftwareInfo') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOASoftwareInfo (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSOASoftwareInfo @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAErrorString') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSOAErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSOAErrorString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSOAErrorString (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSOAErrorString @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCompany') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetCompany
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCompany') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetCompany (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetCompany @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLastName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetLastName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLastName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetLastName (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetLastName @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetAddress') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetAddress
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetAddress') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetAddress (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetAddress @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetAddress2') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetAddress2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetAddress2') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetAddress2 (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetAddress2 @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLastLine') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetLastLine
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetLastLine') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetLastLine (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetLastLine @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSuite') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetSuite
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetSuite') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetSuite (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetSuite @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCity') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetCity
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCity') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetCity (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetCity @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetState') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetState
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetState') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetState (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetState @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetZip') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetZip (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetZip @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPlus4') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetPlus4
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetPlus4') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetPlus4 (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetPlus4 @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetUrbanization') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetUrbanization
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetUrbanization') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetUrbanization (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetUrbanization @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedAddressRange') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedAddressRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedAddressRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedAddressRange (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedAddressRange @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedPreDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedPreDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedPreDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedPreDirection (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedPreDirection @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedStreetName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedStreetName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedStreetName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedStreetName (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedStreetName @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuffix') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuffix') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedSuffix (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedSuffix @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedPostDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedPostDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedPostDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedPostDirection (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedPostDirection @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuiteName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedSuiteName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuiteName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedSuiteName (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedSuiteName @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuiteRange') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedSuiteRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedSuiteRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedSuiteRange (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedSuiteRange @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedRouteService') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedRouteService
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedRouteService') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedRouteService (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedRouteService @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedLockBox') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedLockBox
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedLockBox') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedLockBox (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedLockBox @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedDeliveryInstallation') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetParsedDeliveryInstallation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetParsedDeliveryInstallation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetParsedDeliveryInstallation (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetParsedDeliveryInstallation @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCountryCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetCountryCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetCountryCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetCountryCode (@mdAddr int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetCountryCode @mdAddr, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrVerifyAddress') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrVerifyAddress
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrVerifyAddress') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrVerifyAddress (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrVerifyAddress @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCompany') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCompany
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCompany') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCompany (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCompany @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLastName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetLastName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLastName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetLastName (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetLastName @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddress') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetAddress
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddress') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetAddress (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetAddress @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddress2') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetAddress2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddress2') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetAddress2 (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetAddress2 @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuite') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSuite
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuite') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSuite (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSuite @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCity') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCity
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCity') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCity (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCity @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCityAbbreviation') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCityAbbreviation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCityAbbreviation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCityAbbreviation (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCityAbbreviation @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetState') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetState
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetState') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetState (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetState @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetZip') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetZip (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetZip @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPlus4') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPlus4
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPlus4') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPlus4 (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetPlus4 @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCarrierRoute') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCarrierRoute
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCarrierRoute') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCarrierRoute (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCarrierRoute @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDeliveryPointCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDeliveryPointCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDeliveryPointCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDeliveryPointCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDeliveryPointCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDeliveryPointCheckDigit') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDeliveryPointCheckDigit
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDeliveryPointCheckDigit') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDeliveryPointCheckDigit (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDeliveryPointCheckDigit @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountyFips') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCountyFips
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountyFips') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCountyFips (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCountyFips @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountyName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCountyName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountyName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCountyName (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCountyName @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddressTypeCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetAddressTypeCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddressTypeCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetAddressTypeCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetAddressTypeCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddressTypeString') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetAddressTypeString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetAddressTypeString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetAddressTypeString (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetAddressTypeString @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetUrbanization') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetUrbanization
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetUrbanization') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetUrbanization (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetUrbanization @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCongressionalDistrict') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCongressionalDistrict
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCongressionalDistrict') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCongressionalDistrict (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCongressionalDistrict @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACS') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetLACS
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACS') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetLACS (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetLACS @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACSLinkIndicator') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetLACSLinkIndicator
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACSLinkIndicator') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetLACSLinkIndicator (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetLACSLinkIndicator @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetRBDI') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetRBDI
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetRBDI') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetRBDI (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetRBDI @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPrivateMailbox') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPrivateMailbox
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPrivateMailbox') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPrivateMailbox (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetPrivateMailbox @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetTimeZoneCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetTimeZoneCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetTimeZoneCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetTimeZoneCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetTimeZoneCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetTimeZone') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetTimeZone
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetTimeZone') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetTimeZone (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetTimeZone @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetMsa') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetMsa
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetMsa') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetMsa (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetMsa @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPmsa') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPmsa
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPmsa') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPmsa (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetPmsa @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDefaultFlagIndicator') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDefaultFlagIndicator
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDefaultFlagIndicator') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDefaultFlagIndicator (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDefaultFlagIndicator @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuiteStatus') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSuiteStatus
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuiteStatus') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSuiteStatus (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSuiteStatus @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetEWSFlag') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetEWSFlag
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetEWSFlag') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetEWSFlag (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetEWSFlag @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCMRA') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCMRA
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCMRA') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCMRA (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCMRA @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDsfNoStats') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDsfNoStats
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDsfNoStats') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDsfNoStats (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDsfNoStats @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDsfVacant') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDsfVacant
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDsfVacant') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDsfVacant (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDsfVacant @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountryCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetCountryCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetCountryCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetCountryCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetCountryCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetZipType') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetZipType
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetZipType') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetZipType (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetZipType @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFalseTable') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetFalseTable
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetFalseTable') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetFalseTable (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetFalseTable @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDPVFootnotes') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetDPVFootnotes
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetDPVFootnotes') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetDPVFootnotes (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetDPVFootnotes @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACSLinkReturnCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetLACSLinkReturnCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetLACSLinkReturnCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetLACSLinkReturnCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetLACSLinkReturnCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuiteLinkReturnCode') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetSuiteLinkReturnCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetSuiteLinkReturnCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetSuiteLinkReturnCode (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetSuiteLinkReturnCode @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetELotNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetELotNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetELotNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetELotNumber (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetELotNumber @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetELotOrder') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetELotOrder
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetELotOrder') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetELotOrder (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetELotOrder @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrFindSuggestion') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrFindSuggestion
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrFindSuggestion') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrFindSuggestion (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrFindSuggestion @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrFindSuggestionNext') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrFindSuggestionNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrFindSuggestionNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrFindSuggestionNext (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrFindSuggestionNext @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_B6_TotalRecords') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_B6_TotalRecords
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_B6_TotalRecords') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_B6_TotalRecords (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_B6_TotalRecords @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1a_ZIP4Coded') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_C1a_ZIP4Coded
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1a_ZIP4Coded') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_C1a_ZIP4Coded (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_C1a_ZIP4Coded @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1c_DPBCAssigned') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_C1c_DPBCAssigned
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1c_DPBCAssigned') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_C1c_DPBCAssigned (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_C1c_DPBCAssigned @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1d_FiveDigitCoded') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_C1d_FiveDigitCoded
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1d_FiveDigitCoded') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_C1d_FiveDigitCoded (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_C1d_FiveDigitCoded @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1e_CRRTCoded') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_C1e_CRRTCoded
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1e_CRRTCoded') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_C1e_CRRTCoded (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_C1e_CRRTCoded @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1f_eLOTAssigned') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_C1f_eLOTAssigned
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_C1f_eLOTAssigned') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_C1f_eLOTAssigned (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_C1f_eLOTAssigned @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_HighRiseDefault') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_HighRiseDefault
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_HighRiseDefault') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_HighRiseDefault (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_HighRiseDefault @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_HighRiseExact') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_HighRiseExact
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_HighRiseExact') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_HighRiseExact (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_HighRiseExact @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_RuralRouteDefault') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_RuralRouteDefault
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_RuralRouteDefault') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_RuralRouteDefault (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_RuralRouteDefault @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_RuralRouteExact') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_RuralRouteExact
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_RuralRouteExact') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_RuralRouteExact (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_RuralRouteExact @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_LACSCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_LACSCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_LACSCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_LACSCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_LACSCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_EWSCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_EWSCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_EWSCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_EWSCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_EWSCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_DPVCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_E_DPVCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_E_DPVCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_E_DPVCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_E_DPVCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_POBoxCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_POBoxCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_POBoxCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_POBoxCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_POBoxCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_HCExactCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_HCExactCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_HCExactCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_HCExactCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_HCExactCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_FirmCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_FirmCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_FirmCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_FirmCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_FirmCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_GenDeliveryCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_GenDeliveryCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_GenDeliveryCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_GenDeliveryCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_GenDeliveryCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_MilitaryZipCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_MilitaryZipCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_MilitaryZipCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_MilitaryZipCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_MilitaryZipCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_NonDeliveryCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_NonDeliveryCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_NonDeliveryCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_NonDeliveryCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_NonDeliveryCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_StreetCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_StreetCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_StreetCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_StreetCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_StreetCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_HCDefaultCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_HCDefaultCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_HCDefaultCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_HCDefaultCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_HCDefaultCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_OtherCount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_OtherCount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_OtherCount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_OtherCount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_OtherCount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCodeACount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_LacsLinkCodeACount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCodeACount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_LacsLinkCodeACount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_LacsLinkCodeACount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode00Count') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_LacsLinkCode00Count
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode00Count') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_LacsLinkCode00Count (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_LacsLinkCode00Count @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode14Count') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_LacsLinkCode14Count
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode14Count') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_LacsLinkCode14Count (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_LacsLinkCode14Count @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode92Count') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_LacsLinkCode92Count
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode92Count') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_LacsLinkCode92Count (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_LacsLinkCode92Count @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode09Count') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_LacsLinkCode09Count
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_LacsLinkCode09Count') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_LacsLinkCode09Count (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_LacsLinkCode09Count @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_SuiteLinkCodeACount') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_SuiteLinkCodeACount
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_SuiteLinkCodeACount') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_SuiteLinkCodeACount (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_SuiteLinkCodeACount @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_SuiteLinkCode00Count') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetPS3553_X_SuiteLinkCode00Count
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetPS3553_X_SuiteLinkCode00Count') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetPS3553_X_SuiteLinkCode00Count (@mdAddr int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdAddrGetPS3553_X_SuiteLinkCode00Count @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedAddressRange') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedAddressRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedAddressRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedAddressRange (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedAddressRange @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPreDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedPreDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPreDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedPreDirection (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedPreDirection @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedStreetName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedStreetName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedStreetName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedStreetName (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedStreetName @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuffix') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuffix') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedSuffix (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedSuffix @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPostDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedPostDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPostDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedPostDirection (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedPostDirection @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuiteName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedSuiteName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuiteName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedSuiteName (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedSuiteName @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuiteRange') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedSuiteRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedSuiteRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedSuiteRange (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedSuiteRange @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPrivateMailboxName') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedPrivateMailboxName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPrivateMailboxName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedPrivateMailboxName (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedPrivateMailboxName @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPrivateMailboxNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedPrivateMailboxNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedPrivateMailboxNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedPrivateMailboxNumber (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedPrivateMailboxNumber @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedGarbage') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedGarbage
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedGarbage') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedGarbage (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedGarbage @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedRouteService') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedRouteService
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedRouteService') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedRouteService (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedRouteService @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedLockBox') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedLockBox
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedLockBox') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedLockBox (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedLockBox @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedDeliveryInstallation') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetParsedDeliveryInstallation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetParsedDeliveryInstallation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetParsedDeliveryInstallation (@mdAddr int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetParsedDeliveryInstallation @RetVal out,  @mdAddr
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetReserved') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrSetReserved
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrSetReserved') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrSetReserved (@mdAddr int, @Param0  varchar(4096), @Param1  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdAddrSetReserved @mdAddr, @Param0, @Param1
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetReserved') AND type='FN')
BEGIN
   DROP FUNCTION mdAddrGetReserved
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdAddrGetReserved') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdAddrGetReserved (@mdAddr int, @Param0  varchar(4096))
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdAddrGetReserved @RetVal out,  @mdAddr, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseCreate') AND type='FN')
BEGIN
   DROP FUNCTION mdParseCreate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseCreate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseCreate ()
      RETURNS INT AS BEGIN
         DECLARE @mdParse INT
         EXECUTE master.dbo.xp_mdParseCreate @mdParse OUT
         RETURN @mdParse
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseDestroy') AND type='FN')
BEGIN
   DROP FUNCTION mdParseDestroy
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseDestroy') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseDestroy (@mdParse int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdParseDestroy @mdParse
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseInitialize') AND type='FN')
BEGIN
   DROP FUNCTION mdParseInitialize
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseInitialize') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseInitialize (@mdParse int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdParseInitialize @RetVal out,  @mdParse, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetBuildNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetBuildNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetBuildNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetBuildNumber (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetBuildNumber @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParse') AND type='FN')
BEGIN
   DROP FUNCTION mdParseParse
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParse') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseParse (@mdParse int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdParseParse @mdParse, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParseCanadian') AND type='FN')
BEGIN
   DROP FUNCTION mdParseParseCanadian
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParseCanadian') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseParseCanadian (@mdParse int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdParseParseCanadian @mdParse, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParseNext') AND type='FN')
BEGIN
   DROP FUNCTION mdParseParseNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseParseNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseParseNext (@mdParse int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdParseParseNext @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseLastLineParse') AND type='FN')
BEGIN
   DROP FUNCTION mdParseLastLineParse
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseLastLineParse') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseLastLineParse (@mdParse int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdParseLastLineParse @mdParse, @Param0
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetZip') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetZip (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetZip @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPlus4') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetPlus4
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPlus4') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetPlus4 (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetPlus4 @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetCity') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetCity
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetCity') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetCity (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetCity @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetState') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetState
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetState') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetState (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetState @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetStreetName') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetStreetName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetStreetName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetStreetName (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetStreetName @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetRange') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetRange (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetRange @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPreDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetPreDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPreDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetPreDirection (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetPreDirection @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPostDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetPostDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPostDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetPostDirection (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetPostDirection @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuffix') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuffix') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetSuffix (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetSuffix @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuiteName') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetSuiteName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuiteName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetSuiteName (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetSuiteName @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuiteNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetSuiteNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetSuiteNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetSuiteNumber (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetSuiteNumber @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPrivateMailboxNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetPrivateMailboxNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPrivateMailboxNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetPrivateMailboxNumber (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetPrivateMailboxNumber @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPrivateMailboxName') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetPrivateMailboxName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetPrivateMailboxName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetPrivateMailboxName (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetPrivateMailboxName @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetGarbage') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetGarbage
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetGarbage') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetGarbage (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetGarbage @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetRouteService') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetRouteService
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetRouteService') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetRouteService (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetRouteService @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetGetLockBox') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetGetLockBox
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetGetLockBox') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetGetLockBox (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetGetLockBox @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetDeliveryInstallation') AND type='FN')
BEGIN
   DROP FUNCTION mdParseGetDeliveryInstallation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdParseGetDeliveryInstallation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdParseGetDeliveryInstallation (@mdParse int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdParseGetDeliveryInstallation @RetVal out,  @mdParse
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetCreate') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetCreate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetCreate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetCreate ()
      RETURNS INT AS BEGIN
         DECLARE @mdStreet INT
         EXECUTE master.dbo.xp_mdStreetCreate @mdStreet OUT
         RETURN @mdStreet
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetDestroy') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetDestroy
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetDestroy') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetDestroy (@mdStreet int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdStreetDestroy @mdStreet
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetInitialize') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetInitialize
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetInitialize') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetInitialize (@mdStreet int, @Param0  varchar(4096), @Param1  varchar(4096), @Param2  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetInitialize @RetVal out,  @mdStreet, @Param0, @Param1, @Param2
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetInitializeErrorString') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetInitializeErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetInitializeErrorString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetInitializeErrorString (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetInitializeErrorString @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetDatabaseDate') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetDatabaseDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetDatabaseDate (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetDatabaseDate @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetBuildNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetBuildNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetBuildNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetBuildNumber (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetBuildNumber @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetSetLicenseString') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetSetLicenseString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetSetLicenseString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetSetLicenseString (@mdStreet int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetSetLicenseString @RetVal out,  @mdStreet, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLicenseExpirationDate') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetLicenseExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLicenseExpirationDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetLicenseExpirationDate (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetLicenseExpirationDate @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetFindStreet') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetFindStreet
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetFindStreet') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetFindStreet (@mdStreet int, @Param0  varchar(4096), @Param1  varchar(4096), @Param2  int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetFindStreet @RetVal out,  @mdStreet, @Param0, @Param1, @Param2
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetFindStreetNext') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetFindStreetNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetFindStreetNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetFindStreetNext (@mdStreet int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetFindStreetNext @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetIsAddressInRange') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetIsAddressInRange
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetIsAddressInRange') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetIsAddressInRange (@mdStreet int, @Param0  varchar(4096), @Param1  varchar(4096), @Param2  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetIsAddressInRange @RetVal out,  @mdStreet, @Param0, @Param1, @Param2
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetIsAddressInRange2') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetIsAddressInRange2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetIsAddressInRange2') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetIsAddressInRange2 (@mdStreet int, @Param0  varchar(4096), @Param1  varchar(4096), @Param2  varchar(4096), @Param3  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdStreetIsAddressInRange2 @RetVal out,  @mdStreet, @Param0, @Param1, @Param2, @Param3
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetBaseAlternateIndicator') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetBaseAlternateIndicator
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetBaseAlternateIndicator') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetBaseAlternateIndicator (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetBaseAlternateIndicator @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLACSIndicator') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetLACSIndicator
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLACSIndicator') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetLACSIndicator (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetLACSIndicator @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetUrbanizationCode') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetUrbanizationCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetUrbanizationCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetUrbanizationCode (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetUrbanizationCode @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetUrbanizationName') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetUrbanizationName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetUrbanizationName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetUrbanizationName (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetUrbanizationName @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLastLineNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetLastLineNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetLastLineNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetLastLineNumber (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetLastLineNumber @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetAddressType') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetAddressType
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetAddressType') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetAddressType (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetAddressType @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCongressionalDistrict') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetCongressionalDistrict
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCongressionalDistrict') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetCongressionalDistrict (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetCongressionalDistrict @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCountyFips') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetCountyFips
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCountyFips') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetCountyFips (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetCountyFips @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCarrierRoute') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetCarrierRoute
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCarrierRoute') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetCarrierRoute (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetCarrierRoute @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetZip') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetZip (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetZip @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetDeliveryInstallation') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetDeliveryInstallation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetDeliveryInstallation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetDeliveryInstallation (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetDeliveryInstallation @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPlus4High') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPlus4High
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPlus4High') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPlus4High (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPlus4High @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPlus4Low') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPlus4Low
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPlus4Low') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPlus4Low (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPlus4Low @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeOddEven') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetSuiteRangeOddEven
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeOddEven') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetSuiteRangeOddEven (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetSuiteRangeOddEven @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeHigh') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetSuiteRangeHigh
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeHigh') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetSuiteRangeHigh (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetSuiteRangeHigh @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeLow') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetSuiteRangeLow
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteRangeLow') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetSuiteRangeLow (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetSuiteRangeLow @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteName') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetSuiteName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuiteName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetSuiteName (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetSuiteName @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPostDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPostDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPostDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPostDirection (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPostDirection @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuffix') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetSuffix') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetSuffix (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetSuffix @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetStreetName') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetStreetName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetStreetName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetStreetName (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetStreetName @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPreDirection') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPreDirection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPreDirection') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPreDirection (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPreDirection @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeOddEven') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPrimaryRangeOddEven
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeOddEven') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPrimaryRangeOddEven (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPrimaryRangeOddEven @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeHigh') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPrimaryRangeHigh
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeHigh') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPrimaryRangeHigh (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPrimaryRangeHigh @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeLow') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetPrimaryRangeLow
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetPrimaryRangeLow') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetPrimaryRangeLow (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetPrimaryRangeLow @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCompany') AND type='FN')
BEGIN
   DROP FUNCTION mdStreetGetCompany
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdStreetGetCompany') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdStreetGetCompany (@mdStreet int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdStreetGetCompany @RetVal out,  @mdStreet
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipCreate') AND type='FN')
BEGIN
   DROP FUNCTION mdZipCreate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipCreate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipCreate ()
      RETURNS INT AS BEGIN
         DECLARE @mdZip INT
         EXECUTE master.dbo.xp_mdZipCreate @mdZip OUT
         RETURN @mdZip
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipDestroy') AND type='FN')
BEGIN
   DROP FUNCTION mdZipDestroy
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipDestroy') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipDestroy (@mdZip int)
      RETURNS INT AS BEGIN
         execute master.dbo.xp_mdZipDestroy @mdZip
         RETURN NULL
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipInitialize') AND type='FN')
BEGIN
   DROP FUNCTION mdZipInitialize
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipInitialize') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipInitialize (@mdZip int, @Param0  varchar(4096), @Param1  varchar(4096), @Param2  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipInitialize @RetVal out,  @mdZip, @Param0, @Param1, @Param2
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetInitializeErrorString') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetInitializeErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetInitializeErrorString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetInitializeErrorString (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetInitializeErrorString @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetDatabaseDate') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetDatabaseDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetDatabaseDate (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetDatabaseDate @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetBuildNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetBuildNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetBuildNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetBuildNumber (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetBuildNumber @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipSetLicenseString') AND type='FN')
BEGIN
   DROP FUNCTION mdZipSetLicenseString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipSetLicenseString') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipSetLicenseString (@mdZip int, @Param0  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipSetLicenseString @RetVal out,  @mdZip, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLicenseExpirationDate') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetLicenseExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLicenseExpirationDate') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetLicenseExpirationDate (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetLicenseExpirationDate @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZip') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindZip (@mdZip int, @Param0  varchar(4096), @Param1  int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindZip @RetVal out,  @mdZip, @Param0, @Param1
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipNext') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindZipNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindZipNext (@mdZip int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindZipNext @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipInCity') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindZipInCity
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipInCity') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindZipInCity (@mdZip int, @Param0  varchar(4096), @Param1  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindZipInCity @RetVal out,  @mdZip, @Param0, @Param1
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipInCityNext') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindZipInCityNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindZipInCityNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindZipInCityNext (@mdZip int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindZipInCityNext @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindCityInState') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindCityInState
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindCityInState') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindCityInState (@mdZip int, @Param0  varchar(4096), @Param1  varchar(4096))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindCityInState @RetVal out,  @mdZip, @Param0, @Param1
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindCityInStateNext') AND type='FN')
BEGIN
   DROP FUNCTION mdZipFindCityInStateNext
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipFindCityInStateNext') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipFindCityInStateNext (@mdZip int)
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipFindCityInStateNext @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipComputeDistance') AND type='FN')
BEGIN
   DROP FUNCTION mdZipComputeDistance
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipComputeDistance') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipComputeDistance (@mdZip int, @Param0  float(24), @Param1  float(24), @Param2  float(24), @Param3  float(24))
      RETURNS FLOAT(24) AS BEGIN
         declare @RetVal float(24)
         execute master.dbo.xp_mdZipComputeDistance @RetVal out,  @mdZip, @Param0, @Param1, @Param2, @Param3
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipComputeBearing') AND type='FN')
BEGIN
   DROP FUNCTION mdZipComputeBearing
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipComputeBearing') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipComputeBearing (@mdZip int, @Param0  float(24), @Param1  float(24), @Param2  float(24), @Param3  float(24))
      RETURNS FLOAT(24) AS BEGIN
         declare @RetVal float(24)
         execute master.dbo.xp_mdZipComputeBearing @RetVal out,  @mdZip, @Param0, @Param1, @Param2, @Param3
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyNameFromFips') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetCountyNameFromFips
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyNameFromFips') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetCountyNameFromFips (@mdZip int, @Param0  varchar(4096))
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetCountyNameFromFips @RetVal out,  @mdZip, @Param0
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetSCFArea') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetSCFArea
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetSCFArea') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetSCFArea (@mdZip int, @Param0  varchar(4096), @Param1  float(24), @Param2  float(24), @Param3  float(24), @Param4  float(24))
      RETURNS INT AS BEGIN
         declare @RetVal int
         execute master.dbo.xp_mdZipGetSCFArea @RetVal out,  @mdZip, @Param0, @Param1, @Param2, @Param3, @Param4
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetZip') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetZip
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetZip') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetZip (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetZip @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCity') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetCity
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCity') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetCity (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetCity @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCityAbbreviation') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetCityAbbreviation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCityAbbreviation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetCityAbbreviation (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetCityAbbreviation @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetState') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetState
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetState') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetState (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetState @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetZipType') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetZipType
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetZipType') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetZipType (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetZipType @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyName') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetCountyName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyName') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetCountyName (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetCountyName @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyFips') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetCountyFips
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetCountyFips') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetCountyFips (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetCountyFips @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetAreaCode') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetAreaCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetAreaCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetAreaCode (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetAreaCode @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLongitude') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetLongitude
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLongitude') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetLongitude (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetLongitude @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLatitude') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetLatitude
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLatitude') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetLatitude (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetLatitude @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetTimeZone') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetTimeZone
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetTimeZone') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetTimeZone (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetTimeZone @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetTimeZoneCode') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetTimeZoneCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetTimeZoneCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetTimeZoneCode (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetTimeZoneCode @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetMsa') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetMsa
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetMsa') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetMsa (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetMsa @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetPmsa') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetPmsa
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetPmsa') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetPmsa (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetPmsa @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetFacilityCode') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetFacilityCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetFacilityCode') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetFacilityCode (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetFacilityCode @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLastLineIndicator') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetLastLineIndicator
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLastLineIndicator') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetLastLineIndicator (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetLastLineIndicator @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLastLineNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetLastLineNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetLastLineNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetLastLineNumber (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetLastLineNumber @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetPreferredLastLineNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetPreferredLastLineNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetPreferredLastLineNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetPreferredLastLineNumber (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetPreferredLastLineNumber @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetAutomation') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetAutomation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetAutomation') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetAutomation (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetAutomation @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetFinanceNumber') AND type='FN')
BEGIN
   DROP FUNCTION mdZipGetFinanceNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdZipGetFinanceNumber') AND type='FN')
BEGIN
   EXECUTE dbo.sp_executesql @Statement=N'
      CREATE FUNCTION mdZipGetFinanceNumber (@mdZip int)
      RETURNS VARCHAR(256) AS BEGIN
         declare @RetVal varchar(256)
         execute master.dbo.xp_mdZipGetFinanceNumber @RetVal out,  @mdZip
         RETURN @RetVal
      END
   '
END
GO

